/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

#ifndef MX_ARCH_IO_H
#define MX_ARCH_IO_H

#define MX_IO(command) CTL_CODE(FILE_DEVICE_UNKNOWN, 0x800+command, \
                                METHOD_NEITHER, FILE_ANY_ACCESS)

#define MX_IOCTL_FOO MX_IO(101)
#define MX_IOCTL_BAR MX_IO(102)
#define MX_IOCTL_HANG1 MX_IO(103)
#define MX_IOCTL_HANG2 MX_IO(104)
#define MX_IOCTL_HANG3 MX_IO(105)
#define MX_IOCTL_HANG4 MX_IO(106)
#define MX_IOCTL_HANG5 MX_IO(107)
#define MX_IOCTL_HANG6 MX_IO(108)
#define MX_IOCTL_HANG7 MX_IO(109)
#define MX_IOCTL_HANG8 MX_IO(110)
#define MX_IOCTL_EXCHANGE_CALLBACKS MX_IO(111)

/* TODO: Find another place to put these? */
#define EPERM 1
#define ENOENT 2
#define ESRCH 3
#define EINTR 4
#define EIO 5
#define ENXIO 6
#define E2BIG 7
#define EBADF 9
#define EAGAIN 11
#define ENOMEM 12
#define EFAULT 14
#define EBUSY 16
#define ENODEV 19
#define EINVAL 22
#define ENOTTY 25
#define ENOSPC 28
#define ERANGE 34

#endif
